/* expInt.cpp */

#include "fp.h"

// this is E_n(z) = int(1 to inf) e^(-z*t)/t^n   n>=0, z>0, z=0 & n=1 not allowed
// see p. 228 of "Handbook of Mathematical Functions"
// use 5.1.45: E(n, x) = myLargeGamma(1-n, x)
bool expInt(fp& z, fp& n, fp& x)
{
	fp			xt, temp, one=1.;
	
	z = 0;
	
	if(x.i.n==0 && n<=one)
		return false;
	
	if(x.i.n<0)
		return false;
	
	if(!x.i.n)
	{
		z = one/(n-one);
		return true;
	}
	
	xt = x;
	largeIncompleteGamma(z, one-n, xt);
	
	pow(temp, x, n-one);
	
	z = z*temp;
	
	return true;
		
}/* expInt */

